USE [NWIC_PanelMgmt]
GO

--IF (SELECT OBJECT_ID('App.NVCC_Announcement')) IS NOT NULL DROP TABLE App.NVCC_Announcement

--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Brian Diggs
--Object/SP Name        : NVCC_Announcement
--Server                : SERVER      
--Data Base             : NWIC_PanelMgmt
--Schema                : App
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 06-06-2016
--
--
--Last Changed          :
--Last Changed By		:
--Reason For Change		:
--
--Purpose               : Fact table for announcements
--==================================================================================

CREATE TABLE App.NVCC_Announcement (
	AnnouncementID int NOT NULL identity(1,1) PRIMARY KEY,
	AnnouncementTypeID int NOT NULL,
	Creator varchar(50) NOT NULL,
	-- datetime of creation, in UTC time
	CreationDT datetime2 NOT NULL CONSTRAINT DF_Announcement_CreationDT DEFAULT SYSUTCDATETIME(),
	-- datetime of expiration, in UTC time
	ExpirationDT datetime2,
	Text nvarchar(4000)
) ON [DefFG] with (DATA_COMPRESSION = PAGE)

CREATE INDEX AnnouncementTypeID_Announcement
ON App.NVCC_Announcement (AnnouncementTypeID)
ON [DefFG]

CREATE INDEX ExiprationDT_Announcement
ON App.NVCC_Announcement (ExpirationDT)
ON [DefFG] 